/*
 * Decompiled with CFR 0.152.
 */
package me.seafoam.minecraft.seafoamy.util;

public class Location {
    private String server;
    private String world;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    public Location(String server, String world, double x, double y, double z, float yaw, float pitch) {
        this.server = server;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Location(String world, double x, double y, double z, float yaw, float pitch) {
        this(null, world, x, y, z, yaw, pitch);
    }

    public Location(double x, double y, double z, float yaw, float pitch) {
        this(null, null, x, y, z, yaw, pitch);
    }

    public Location(double x, double y, double z) {
        this(null, null, x, y, z, 0.0f, 0.0f);
    }

    public int getBlockX() {
        return (int)Math.floor(this.x);
    }

    public int getBlockY() {
        return (int)Math.floor(this.y);
    }

    public int getBlockZ() {
        return (int)Math.floor(this.z);
    }

    public Location lookAt(Location lookAt) {
        double dx = lookAt.getX() - this.getX();
        double dy = lookAt.getY() - this.getY();
        double dz = lookAt.getZ() - this.getZ();
        if (dx != 0.0) {
            if (dx < 0.0) {
                this.setYaw(4.712389f);
            } else {
                this.setYaw(1.5707964f);
            }
            this.setYaw(this.getYaw() - (float)Math.atan(dz / dx));
        } else if (dz < 0.0) {
            this.setYaw((float)Math.PI);
        }
        double dxz = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dz, 2.0));
        this.setPitch((float)(-Math.atan(dy / dxz)));
        this.setYaw(-this.getYaw() * 180.0f / (float)Math.PI);
        this.setPitch(this.getPitch() * 180.0f / (float)Math.PI);
        return this;
    }

    public Location clone() {
        return new Location(this.server, this.world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public String getServer() {
        return this.server;
    }

    public String getWorld() {
        return this.world;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }
}

