/*
 * Decompiled with CFR 0.152.
 */
package me.seafoam.minecraft.seafoamy.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

public class ConfigManager {
    private static final Gson gson = new GsonBuilder().setLenient().create();

    public static <T> T load(File dataFolder, String path, Class<T> clazz) {
        try {
            Path filePath;
            if (!((String)path).endsWith(".json")) {
                path = (String)path + ".json";
            }
            if (!Files.exists(filePath = dataFolder.toPath().resolve((String)path), new LinkOption[0])) {
                try {
                    URI uri = clazz.getResource("/" + (String)path).toURI();
                    HashMap env = new HashMap();
                    String[] array = uri.toString().split("!");
                    FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), env);
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                    Files.copy(fs.getPath(array[1], new String[0]), filePath, new CopyOption[0]);
                    fs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            String json = Files.readString(dataFolder.toPath().resolve((String)path));
            return (T)gson.fromJson(json, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

