/*
 * Decompiled with CFR 0.152.
 */
package me.seafoam.minecraft.seafoamy.text;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class Language {
    private static final HashMap<String, Language> languages = new HashMap();
    private static Language defaultLanguage;
    private final String code;
    private final HashMap<String, String> map = new HashMap();

    private Language(String code) {
        this.code = code;
    }

    public static Language loadLanguage(String code, String namespace, String json) {
        Language lang = languages.computeIfAbsent(code, Language::new);
        Map jsonMap = (Map)new Gson().fromJson(json, Map.class);
        for (Map.Entry entry : jsonMap.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof String) {
                String s = (String)v;
                lang.map.put(namespace + ":" + entry.getKey(), s);
                continue;
            }
            v = entry.getValue();
            if (!(v instanceof LinkedTreeMap)) continue;
            LinkedTreeMap tree = (LinkedTreeMap)v;
            lang.next(namespace + ":" + entry.getKey(), tree);
        }
        return lang;
    }

    public static Language loadLanguage(String code, String namespace, Object plugin) {
        try {
            URI uri = plugin.getClass().getClassLoader().getResource("lang/" + code + ".json").toURI();
            HashMap env = new HashMap();
            String[] array = uri.toString().split("!");
            FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), env);
            String jsonString = Files.readString(fs.getPath(array[1], new String[0]));
            fs.close();
            return Language.loadLanguage(code, namespace, jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void loadAllLanguages(Object plugin, String namespace) {
        try {
            URI uri = plugin.getClass().getClassLoader().getResource("lang").toURI();
            HashMap env = new HashMap();
            String[] array = uri.toString().split("!");
            FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), env);
            Path path = fs.getPath(array[1], new String[0]);
            try (Stream<Path> files = Files.list(path);){
                files.forEach(p -> {
                    try {
                        String jsonString = Files.readString(p);
                        String code = p.getFileName().toString().replace(".json", "");
                        Language.loadLanguage(code, namespace, jsonString);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            fs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void next(String key, LinkedTreeMap<?, ?> tree) {
        for (Map.Entry entry : tree.entrySet()) {
            String fullKey = key + "." + entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String) {
                String s = (String)v;
                this.map.put(fullKey, s);
                continue;
            }
            v = entry.getValue();
            if (!(v instanceof LinkedTreeMap)) continue;
            LinkedTreeMap nextTree = (LinkedTreeMap)v;
            this.next(fullKey, nextTree);
        }
    }

    public String translate(String key) {
        return this.map.getOrDefault(key, key);
    }

    public static Language getLanguage(String code) {
        return languages.get(code);
    }

    public static Language getDefaultLanguage() {
        return defaultLanguage;
    }

    public static void setDefaultLanguage(Language defaultLanguage) {
        Language.defaultLanguage = defaultLanguage;
    }

    public String getCode() {
        return this.code;
    }
}

