/*
 * Decompiled with CFR 0.152.
 */
package me.seafoam.minecraft.seafoamy.player;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.seafoam.minecraft.seafoamy.player.OnlinePlayer;

public abstract class PlayerManager<T extends OnlinePlayer, P> {
    protected List<T> onlinePlayers = new ArrayList<T>();

    public abstract T getOnlinePlayer(P var1);

    public T getOnlinePlayer(UUID uuid) {
        for (OnlinePlayer player : this.onlinePlayers) {
            if (!player.getUniqueId().equals(uuid)) continue;
            return (T)player;
        }
        return null;
    }

    public T getOnlinePlayer(String name) {
        for (OnlinePlayer player : this.onlinePlayers) {
            if (!player.getName().equalsIgnoreCase(name)) continue;
            return (T)player;
        }
        return null;
    }

    public List<T> getAllPlayers() {
        return new ArrayList<T>(this.onlinePlayers);
    }

    public void addPlayer(T player) {
        this.onlinePlayers.add(player);
    }

    public void removePlayer(T player) {
        this.onlinePlayers.remove(player);
    }

    public abstract T registerPlayer(P var1);

    public abstract T unregisterPlayer(P var1);
}

