/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot.api.command;

import com.siblaze.disbot.api.DiscordBot;
import com.siblaze.disbot.api.command.CommandManager;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.InteractionHook;

public class CommandEvent {
    private final String label;
    private User user;
    private Member member;
    private MessageChannel channel;
    private Message message;
    private Guild guild;
    private boolean slashCommand;
    private SlashCommandInteractionEvent slashCommandEvent;
    private final CommandManager commandManager;
    private final DiscordBot bot;
    private final JDA jda;

    protected CommandEvent(String label, CommandManager commandManager) {
        this.label = label;
        this.commandManager = commandManager;
        this.jda = commandManager.getJda();
        this.bot = commandManager.getBot();
    }

    protected CommandEvent setUser(User user) {
        this.user = user;
        return this;
    }

    protected CommandEvent setMember(Member member) {
        this.member = member;
        return this;
    }

    protected CommandEvent setChannel(MessageChannelUnion channel) {
        this.channel = channel;
        return this;
    }

    protected CommandEvent setMessage(Message message) {
        this.message = message;
        return this;
    }

    protected CommandEvent setGuild(Guild guild) {
        this.guild = guild;
        return this;
    }

    protected CommandEvent setSlashCommand(boolean slash) {
        this.slashCommand = slash;
        return this;
    }

    protected CommandEvent setSlashCommandEvent(SlashCommandInteractionEvent event) {
        this.slashCommandEvent = event;
        return this;
    }

    public boolean isGuild() {
        return this.guild != null;
    }

    public boolean isDirectMessage() {
        return this.guild == null;
    }

    public void queueMessage(String message) {
        if (this.isSlashCommand()) {
            this.slashCommandEvent.reply(message).queue();
        } else {
            this.channel.sendMessage((CharSequence)message).queue();
        }
    }

    public void completeMessage(String message) {
        if (this.isSlashCommand()) {
            this.slashCommandEvent.reply(message).complete();
        } else {
            this.channel.sendMessage((CharSequence)message).complete();
        }
    }

    public void queueMessage(MessageEmbed embed) {
        if (this.isSlashCommand()) {
            this.slashCommandEvent.replyEmbeds(embed, new MessageEmbed[0]).queue();
        } else {
            this.channel.sendMessageEmbeds(embed, new MessageEmbed[0]).queue();
        }
    }

    public Message completeMessage(MessageEmbed embed) {
        if (this.isSlashCommand()) {
            return (Message)((InteractionHook)this.slashCommandEvent.replyEmbeds(embed, new MessageEmbed[0]).complete()).retrieveOriginal().complete();
        }
        return (Message)this.channel.sendMessageEmbeds(embed, new MessageEmbed[0]).complete();
    }

    public String getLabel() {
        return this.label;
    }

    public User getUser() {
        return this.user;
    }

    public Member getMember() {
        return this.member;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public Message getMessage() {
        return this.message;
    }

    public Guild getGuild() {
        return this.guild;
    }

    public boolean isSlashCommand() {
        return this.slashCommand;
    }

    public SlashCommandInteractionEvent getSlashCommandEvent() {
        return this.slashCommandEvent;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public DiscordBot getBot() {
        return this.bot;
    }

    public JDA getJda() {
        return this.jda;
    }
}

