/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot.api;

import com.siblaze.disbot.api.DiscordBot;
import java.util.function.BiFunction;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;

public interface Ability {
    public boolean hasAbility(DiscordBot var1, Member var2);

    public DefaultMemberPermissions getSlashCommandPermission();

    public static Ability of(final Permission ... permissions) {
        return new Ability(){

            @Override
            public boolean hasAbility(DiscordBot bot, Member member) {
                return member.hasPermission(permissions);
            }

            @Override
            public DefaultMemberPermissions getSlashCommandPermission() {
                return DefaultMemberPermissions.enabledFor((Permission[])permissions);
            }
        };
    }

    public static Ability of(final BiFunction<DiscordBot, Member, Boolean> function, final DefaultMemberPermissions permission) {
        return new Ability(){

            @Override
            public boolean hasAbility(DiscordBot bot, Member member) {
                return (Boolean)function.apply(bot, member);
            }

            @Override
            public DefaultMemberPermissions getSlashCommandPermission() {
                return permission;
            }
        };
    }

    public static Ability of(BiFunction<DiscordBot, Member, Boolean> function, Permission ... permissions) {
        return Ability.of(function, DefaultMemberPermissions.enabledFor((Permission[])permissions));
    }

    public static Ability of(BiFunction<DiscordBot, Member, Boolean> function) {
        return Ability.of(function, DefaultMemberPermissions.ENABLED);
    }
}

